<?php
/**
 * @author Thecommerceshop Team
 * @copyright Copyright (c) 2023 Thecommerceshop (https://www.thecommerceshop.com/)
 * @package Bulk Coupon Delete Magento 2 
 */

namespace Thecommerceshop\Bulkcoupondelete\Controller\Adminhtml\Coupondelete;
use Magento\SalesRule\Api\RuleRepositoryInterface;
use Psr\Log\LoggerInterface;
class Index extends \Magento\Backend\App\Action
{
     /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var RuleRepositoryInterface
     */
    protected $ruleRepository;
    protected $resultPageFactory;
    protected $messageManager;
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Magento\Framework\Controller\Result\RedirectFactory $resultRedirectFactory,
         LoggerInterface $logger,
         RuleRepositoryInterface $ruleRepository,
        \Magento\Framework\Message\ManagerInterface $messageManager
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->resultRedirectFactory = $resultRedirectFactory;
        $this->ruleRepository = $ruleRepository;
        $this->logger = $logger;
        $this->ruleRepository = $ruleRepository;
        $this->messageManager = $messageManager;
        
        parent::__construct($context);
    }
    
     /**
     * Check admin permissions for this controller
     *
     * @return boolean
     */
    // protected function _isAllowed()
    // {
    //     return $this->_authorization->isAllowed('Thecommerceshop_Bulkcoupondelete::coupondelete');
    // }

    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();
        $salesrule = $this->getRequest()->getParam('salesrule');

        foreach($salesrule as $salesruleid){
        $this->ruleRepository->deleteById($salesruleid);
        }
        $this->messageManager->addSuccess(__('Total of' . count($salesrule). 'rule(s) were successfully deleted.' ));
         return $resultRedirect->setPath('sales_rule/promo_quote/');
    }
    
}