Overview :
This custom module integrates a Lazy Video feature into Magento 2's Page Builder. It allows you to easily embed YouTube videos with lazy loading functionality into product descriptions or content sections in your Magento store.

Installation :
Download the Module:

Clone or download this repository and place the contents into your Magento 2 installation directory.

Enable the Module:

Run the following commands in your Magento 2 root directory:
bin/magento module:enable Custom_LazyVideo
bin/magento setup:upgrade
bin/magento cache:flush


Usage
Add the Lazy Video Script:

In the Magento Admin Panel, navigate to Content Design Configuration and in the Footer's Miscellaneous HTML section, add the following script:


Add the Lazy Video Script:

In the Magento Admin Panel, navigate to Content Design Configuration and in the Footer's Miscellaneous HTML section, add the following script:

<script>
(function () {  let YouTubeContainers = document.getElementsByClassName("tcs-embed-youtube");    function createImageElement(videosrc) {    let pictureElement = document.createElement('picture');    let webpSource = document.createElement('source');    webpSource.setAttribute('srcset', `https://i.ytimg.com/vi_webp/${videosrc}/sddefault.webp`);    webpSource.setAttribute('type', 'image/webp');    webpSource.setAttribute('alt', 'Product Description video');    pictureElement.appendChild(webpSource);    let fallbackImage = document.createElement('img');    fallbackImage.setAttribute('src', `https://img.youtube.com/vi/${videosrc}/sddefault.jpg`);    fallbackImage.setAttribute('alt', 'Product Description video');    pictureElement.appendChild(fallbackImage);    return pictureElement;  }  function loadVideo(container, ivideosrc) {    let iframe = document.createElement("iframe");    iframe.setAttribute("frameborder", "0");    iframe.setAttribute("allowfullscreen", "");    iframe.setAttribute("allow", "accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture");    iframe.setAttribute("src", `https://www.youtube.com/embed/${ivideosrc}?rel=0&showinfo=0&autoplay=1`);        container.innerHTML = "";    container.appendChild(iframe);  }  for (let i = 0; i < YouTubeContainers.length; i++) {    let container = YouTubeContainers[i];    let url = container.dataset.videoId;    let videosrc = "p2vpqKBPj4U";    if (url) {      const URLparams = new URLSearchParams(url.split('?')[1]);      videosrc = URLparams.get('v') || videosrc;    }    let pictureElement = createImageElement(videosrc);    container.appendChild(pictureElement);    let image = new Image();    image.src = `https://i.ytimg.com/vi_webp/${videosrc}/sddefault.webp`;    image.addEventListener("load", function () {      container.appendChild(pictureElement);      image.setAttribute('loading', 'lazy');    });    container.addEventListener("click", function () {      let iurl = container.dataset.videoId || "";      let ivideosrc = "p2vpqKBPj4U";      if (iurl) {        const IURLparams = new URLSearchParams(iurl.split('?')[1]);        ivideosrc = IURLparams.get('v') || ivideosrc;      }      loadVideo(container, ivideosrc);    });  }})();
</script>


Embed Lazy Video in Page Builder:

Open any product or content section in the Magento Admin Panel.
If editing a product, click "Edit Product"; if editing content, click "Edit Content."
In the Page Builder, add an HTML code element to the content.
Inside the HTML code element, add a row.
Find the "Lazy Video" attribute and drag it into the row.
Click the settings icon (gear icon) to configure the Lazy Video.
In the "Video URL" input, provide the YouTube link.
Save the Page Builder content as usual.


Author :
TheCommerceShop
contactus@innoppl.com 

License
This project is licensed under the MIT License.
